<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'friends');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('album', 'user', 'posting');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'memberinfo_friends_table',
	'memberinfo_friends_bit',
	'postbit_onlinestatus'
);


// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_postbit.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/functions_bigthree.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT); 
$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);  
$userinfo = fetch_userinfo($userid);
if (!$userinfo) {
	eval(standard_error(fetch_error('invalidid', $vbphrase['user'], $vbulletin->options['contactuslink'])));
}
$navbits = construct_navbits(array('member.php' => $userinfo['username'], '' => $userinfo['username'] . '\'s Friends'));
eval('$navbar = "' . fetch_template('navbar') . '";');

$friends_sql_count = $db->query_first("
	SELECT COUNT(userlist.type) as count	FROM " . TABLE_PREFIX . "userlist AS userlist	
	WHERE userlist.userid = " . $userid . "
		AND userlist.type = 'buddy'
		AND userlist.friend = 'yes'
");
$amount = $friends_sql_count['count'];
sanitize_pageresults($amount, $pagenumber, $perpage, 100, $vbulletin->options['sfp_perpage']);
$limitlower = ($pagenumber - 1) * $perpage + 1; 
$limitupper = $pagenumber * $perpage; 
if ($limitupper > $amount) 
{ 
	// Too many for upper limit 
	$limitupper = $amount; 
	if ($limitlower > $amount) 
	{ 
		$limitlower = $amount - $perpage; 
	} 
} 
if ($limitlower <= 0) 
{ 
	$limitlower = 1; 
} 
$friends_sql = $db->query_read_slave("
	SELECT user.*, (user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible "
	. ($vbulletin->options['avatarenabled'] ?
	", avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.filedata_thumb, customavatar.height AS avheight, customavatar.width AS avwidth, customavatar.width_thumb AS avwidth_thumb, customavatar.height_thumb AS avheight_thumb" : "") . "
	FROM " . TABLE_PREFIX . "userlist AS userlist	
	INNER JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = userlist.relationid)"
	. ($vbulletin->options['avatarenabled'] ? "
	LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)
	LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid) " : '') . "
	$hook_query_joins
	WHERE userlist.userid = " . $userid . "
		AND userlist.type = 'buddy'
		AND userlist.friend = 'yes'
	LIMIT " . ($limitlower - 1) . ", $perpage 
");
 
$pagenav = construct_page_nav($pagenumber, $perpage, $amount, 'friends.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userid);  
$count = 0;
$amount_per = $vbulletin->options['spf_col'];
while ($user = $db->fetch_array($friends_sql))
{
	$show['new_col'] = false;
	if ($amount_per == $count) {
		$show['new_col'] = true;
		$count = 0;
	}
	fetch_avatar_from_userinfo($user, true);
	fetch_musername($user);
	$alt = ($alt == 'alt1') ? 'alt2' : 'alt1';
	$online = fetch_online_status($user, true);
	construct_im_icons($user, true);
	if ($user['userid'] == $vbulletin->userinfo['userid'] OR $userid == $vbulletin->userinfo['userid'])
	{
		if ($user['userid'] == $vbulletin->userinfo['userid'])
		{
			$show['return'] = true;
			$remove = array(
				'userid' => $userid,
				'return' => 1,
			);
		} else {
			$remove = array('userid' => $user['userid']);
		}
		$show['breakfriendship'] = true;
	} else {
		$show['breakfriendship'] = false;
	}
	
	eval('$friendbits .= "' . fetch_template('memberinfo_friends_bit') . '";');
	$count++;
}

eval('print_output("' . fetch_template('memberinfo_friends_table') . '");');
?>